/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.agent.SnmpMib;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmThreadContentionMonitoring;
import sun.management.snmp.jvmmib.EnumJvmThreadCpuTimeMonitoring;
import sun.management.snmp.jvmmib.JvmThreadingMBean;
import sun.management.snmp.util.MibLogger;

public class JvmThreadingImpl
implements JvmThreadingMBean {
    static final EnumJvmThreadCpuTimeMonitoring JvmThreadCpuTimeMonitoringUnsupported = new EnumJvmThreadCpuTimeMonitoring("unsupported");
    static final EnumJvmThreadCpuTimeMonitoring JvmThreadCpuTimeMonitoringEnabled = new EnumJvmThreadCpuTimeMonitoring("enabled");
    static final EnumJvmThreadCpuTimeMonitoring JvmThreadCpuTimeMonitoringDisabled = new EnumJvmThreadCpuTimeMonitoring("disabled");
    static final EnumJvmThreadContentionMonitoring JvmThreadContentionMonitoringUnsupported = new EnumJvmThreadContentionMonitoring("unsupported");
    static final EnumJvmThreadContentionMonitoring JvmThreadContentionMonitoringEnabled = new EnumJvmThreadContentionMonitoring("enabled");
    static final EnumJvmThreadContentionMonitoring JvmThreadContentionMonitoringDisabled = new EnumJvmThreadContentionMonitoring("disabled");
    private long jvmThreadPeakCountReset = 0L;
    static final MibLogger log = new MibLogger(JvmThreadingImpl.class);

    public JvmThreadingImpl(SnmpMib snmpMib) {
        log.debug("JvmThreadingImpl", "Constructor");
    }

    public JvmThreadingImpl(SnmpMib snmpMib, MBeanServer mBeanServer) {
        log.debug("JvmThreadingImpl", "Constructor with server");
    }

    static ThreadMXBean getThreadMXBean() {
        return ManagementFactory.getThreadMXBean();
    }

    public EnumJvmThreadCpuTimeMonitoring getJvmThreadCpuTimeMonitoring() throws SnmpStatusException {
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        if (!threadMXBean.isThreadCpuTimeSupported()) {
            log.debug("getJvmThreadCpuTimeMonitoring", "Unsupported ThreadCpuTimeMonitoring");
            return JvmThreadCpuTimeMonitoringUnsupported;
        }
        try {
            if (threadMXBean.isThreadCpuTimeEnabled()) {
                log.debug("getJvmThreadCpuTimeMonitoring", "Enabled ThreadCpuTimeMonitoring");
                return JvmThreadCpuTimeMonitoringEnabled;
            }
            log.debug("getJvmThreadCpuTimeMonitoring", "Disabled ThreadCpuTimeMonitoring");
            return JvmThreadCpuTimeMonitoringDisabled;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.debug("getJvmThreadCpuTimeMonitoring", "Newly unsupported ThreadCpuTimeMonitoring");
            return JvmThreadCpuTimeMonitoringUnsupported;
        }
    }

    public void setJvmThreadCpuTimeMonitoring(EnumJvmThreadCpuTimeMonitoring enumJvmThreadCpuTimeMonitoring) throws SnmpStatusException {
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        if (JvmThreadCpuTimeMonitoringEnabled.intValue() == enumJvmThreadCpuTimeMonitoring.intValue()) {
            threadMXBean.setThreadCpuTimeEnabled(true);
        } else {
            threadMXBean.setThreadCpuTimeEnabled(false);
        }
    }

    public void checkJvmThreadCpuTimeMonitoring(EnumJvmThreadCpuTimeMonitoring enumJvmThreadCpuTimeMonitoring) throws SnmpStatusException {
        if (JvmThreadCpuTimeMonitoringUnsupported.intValue() == enumJvmThreadCpuTimeMonitoring.intValue()) {
            log.debug("checkJvmThreadCpuTimeMonitoring", "Try to set to illegal unsupported value");
            throw new SnmpStatusException(10);
        }
        if (JvmThreadCpuTimeMonitoringEnabled.intValue() == enumJvmThreadCpuTimeMonitoring.intValue() || JvmThreadCpuTimeMonitoringDisabled.intValue() == enumJvmThreadCpuTimeMonitoring.intValue()) {
            ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
            if (threadMXBean.isThreadCpuTimeSupported()) {
                return;
            }
            log.debug("checkJvmThreadCpuTimeMonitoring", "Unsupported operation, can't set state");
            throw new SnmpStatusException(12);
        }
        log.debug("checkJvmThreadCpuTimeMonitoring", "unknown enum value ");
        throw new SnmpStatusException(10);
    }

    public EnumJvmThreadContentionMonitoring getJvmThreadContentionMonitoring() throws SnmpStatusException {
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        if (!threadMXBean.isThreadContentionMonitoringSupported()) {
            log.debug("getJvmThreadContentionMonitoring", "Unsupported ThreadContentionMonitoring");
            return JvmThreadContentionMonitoringUnsupported;
        }
        if (threadMXBean.isThreadContentionMonitoringEnabled()) {
            log.debug("getJvmThreadContentionMonitoring", "Enabled ThreadContentionMonitoring");
            return JvmThreadContentionMonitoringEnabled;
        }
        log.debug("getJvmThreadContentionMonitoring", "Disabled ThreadContentionMonitoring");
        return JvmThreadContentionMonitoringDisabled;
    }

    public void setJvmThreadContentionMonitoring(EnumJvmThreadContentionMonitoring enumJvmThreadContentionMonitoring) throws SnmpStatusException {
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        if (JvmThreadContentionMonitoringEnabled.intValue() == enumJvmThreadContentionMonitoring.intValue()) {
            threadMXBean.setThreadContentionMonitoringEnabled(true);
        } else {
            threadMXBean.setThreadContentionMonitoringEnabled(false);
        }
    }

    public void checkJvmThreadContentionMonitoring(EnumJvmThreadContentionMonitoring enumJvmThreadContentionMonitoring) throws SnmpStatusException {
        if (JvmThreadContentionMonitoringUnsupported.intValue() == enumJvmThreadContentionMonitoring.intValue()) {
            log.debug("checkJvmThreadContentionMonitoring", "Try to set to illegal unsupported value");
            throw new SnmpStatusException(10);
        }
        if (JvmThreadContentionMonitoringEnabled.intValue() == enumJvmThreadContentionMonitoring.intValue() || JvmThreadContentionMonitoringDisabled.intValue() == enumJvmThreadContentionMonitoring.intValue()) {
            ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
            if (threadMXBean.isThreadContentionMonitoringSupported()) {
                return;
            }
            log.debug("checkJvmThreadContentionMonitoring", "Unsupported operation, can't set state");
            throw new SnmpStatusException(12);
        }
        log.debug("checkJvmThreadContentionMonitoring", "Try to set to unknown value");
        throw new SnmpStatusException(10);
    }

    public Long getJvmThreadTotalStartedCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getTotalStartedThreadCount());
    }

    public Long getJvmThreadPeakCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getPeakThreadCount());
    }

    public Long getJvmThreadDaemonCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getDaemonThreadCount());
    }

    public Long getJvmThreadCount() throws SnmpStatusException {
        return new Long(JvmThreadingImpl.getThreadMXBean().getThreadCount());
    }

    public synchronized Long getJvmThreadPeakCountReset() throws SnmpStatusException {
        return new Long(this.jvmThreadPeakCountReset);
    }

    public synchronized void setJvmThreadPeakCountReset(Long l) throws SnmpStatusException {
        long l2 = l;
        if (l2 > this.jvmThreadPeakCountReset) {
            long l3 = System.currentTimeMillis();
            JvmThreadingImpl.getThreadMXBean().resetPeakThreadCount();
            this.jvmThreadPeakCountReset = l3;
            log.debug("setJvmThreadPeakCountReset", "jvmThreadPeakCountReset=" + l3);
        }
    }

    public void checkJvmThreadPeakCountReset(Long l) throws SnmpStatusException {
    }
}

