/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.mo.util;

import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.PropertyCollector;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyCollectorUtil {
    public static final Object NULL = new Object();

    public static Hashtable[] retrieveProperties(ManagedObject[] mos, String moType, String[] propPaths) throws InvalidProperty, RuntimeFault, RemoteException {
        if (mos == null) {
            throw new IllegalArgumentException("Managed object array cannot be null.");
        }
        if (mos.length == 0 || mos[0] == null) {
            return new Hashtable[0];
        }
        PropertyCollector pc = mos[0].getServerConnection().getServiceInstance().getPropertyCollector();
        ObjectSpec[] oss = new ObjectSpec[mos.length];
        for (int i2 = 0; i2 < oss.length; ++i2) {
            oss[i2] = new ObjectSpec();
            oss[i2].setObj(mos[i2].getMOR());
        }
        PropertySpec pSpec = PropertyCollectorUtil.createPropertySpec(moType, false, propPaths);
        PropertyFilterSpec pfs = new PropertyFilterSpec();
        pfs.setObjectSet(oss);
        pfs.setPropSet(new PropertySpec[]{pSpec});
        ObjectContent[] objs = pc.retrieveProperties(new PropertyFilterSpec[]{pfs});
        Hashtable[] pTables = new Hashtable[mos.length];
        for (int i3 = 0; objs != null && i3 < objs.length && objs[i3] != null; ++i3) {
            DynamicProperty[] props = objs[i3].getPropSet();
            ManagedObjectReference mor = objs[i3].getObj();
            int index = -1;
            if (mor.getType().equals(mos[i3].getMOR().getType()) && mor.get_value().equals(mos[i3].getMOR().get_value())) {
                index = i3;
            } else {
                index = PropertyCollectorUtil.findIndex(mos, mor);
                if (index == -1) {
                    throw new RuntimeException("Unexpected managed object in result: " + mor.getType() + ":" + mor.get_value());
                }
            }
            pTables[index] = new Hashtable();
            for (int j2 = 0; props != null && j2 < props.length; ++j2) {
                Object obj = PropertyCollectorUtil.convertProperty(props[j2].getVal());
                if (obj == null) {
                    obj = NULL;
                }
                pTables[index].put(props[j2].getName(), obj);
            }
        }
        return pTables;
    }

    private static int findIndex(ManagedObject[] mos, ManagedObjectReference mor) {
        for (int i2 = 0; i2 < mos.length; ++i2) {
            if (!mor.getType().equals(mos[i2].getMOR().getType()) || !mor.get_value().equals(mos[i2].getMOR().get_value())) continue;
            return i2;
        }
        return -1;
    }

    public static Object convertProperty(Object dynaPropVal) {
        Object propertyValue = null;
        Class<?> propClass = dynaPropVal.getClass();
        String propName = propClass.getName();
        if (propName.indexOf("ArrayOf") != -1) {
            String methodName = propName.substring(propName.indexOf("ArrayOf") + "ArrayOf".length());
            try {
                Method getMethod = null;
                try {
                    getMethod = propClass.getMethod("get" + methodName, null);
                }
                catch (NoSuchMethodException nsme) {
                    getMethod = propClass.getMethod("get_" + methodName.toLowerCase(), null);
                }
                propertyValue = getMethod.invoke(dynaPropVal, (Object[])null);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        } else {
            propertyValue = dynaPropVal.getClass().isArray() ? dynaPropVal : dynaPropVal;
        }
        return propertyValue;
    }

    public static ObjectSpec creatObjectSpec(ManagedObjectReference mor, boolean skip, SelectionSpec[] selSet) {
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(mor);
        oSpec.setSkip(skip);
        oSpec.setSelectSet(selSet);
        return oSpec;
    }

    public static PropertySpec createPropertySpec(String type, boolean allProp, String[] pathSet) {
        PropertySpec pSpec = new PropertySpec();
        pSpec.setType(type);
        pSpec.setAll(allProp);
        pSpec.setPathSet(pathSet);
        return pSpec;
    }

    public static SelectionSpec[] createSelectionSpec(String[] names) {
        SelectionSpec[] sss = new SelectionSpec[names.length];
        for (int i2 = 0; i2 < names.length; ++i2) {
            sss[i2] = new SelectionSpec();
            sss[i2].setName(names[i2]);
        }
        return sss;
    }

    public static TraversalSpec createTraversalSpec(String name, String type, String path, String[] selectPath) {
        return PropertyCollectorUtil.createTraversalSpec(name, type, path, PropertyCollectorUtil.createSelectionSpec(selectPath));
    }

    public static TraversalSpec createTraversalSpec(String name, String type, String path, SelectionSpec[] selectSet) {
        TraversalSpec ts = new TraversalSpec();
        ts.setName(name);
        ts.setType(type);
        ts.setPath(path);
        ts.setSkip(Boolean.FALSE);
        ts.setSelectSet(selectSet);
        return ts;
    }

    public static PropertySpec[] buildPropertySpecArray(String[][] typeProplists) {
        PropertySpec[] pSpecs = new PropertySpec[typeProplists.length];
        for (int i2 = 0; i2 < typeProplists.length; ++i2) {
            String type = typeProplists[i2][0];
            String[] props = new String[typeProplists[i2].length - 1];
            for (int j2 = 0; j2 < props.length; ++j2) {
                props[j2] = typeProplists[i2][j2 + 1];
            }
            boolean all = props.length == 0;
            pSpecs[i2] = PropertyCollectorUtil.createPropertySpec(type, all, props);
        }
        return pSpecs;
    }

    public static SelectionSpec[] buildFullTraversal() {
        List<TraversalSpec> tSpecs = PropertyCollectorUtil.buildFullTraversalV2NoFolder();
        TraversalSpec visitFolders = PropertyCollectorUtil.createTraversalSpec("visitFolders", "Folder", "childEntity", new String[]{"visitFolders", "dcToHf", "dcToVmf", "crToH", "crToRp", "HToVm", "rpToVm"});
        SelectionSpec[] sSpecs = new SelectionSpec[tSpecs.size() + 1];
        sSpecs[0] = visitFolders;
        for (int i2 = 1; i2 < sSpecs.length; ++i2) {
            sSpecs[i2] = tSpecs.get(i2 - 1);
        }
        return sSpecs;
    }

    private static List<TraversalSpec> buildFullTraversalV2NoFolder() {
        TraversalSpec rpToRp = PropertyCollectorUtil.createTraversalSpec("rpToRp", "ResourcePool", "resourcePool", new String[]{"rpToRp", "rpToVm"});
        TraversalSpec rpToVm = PropertyCollectorUtil.createTraversalSpec("rpToVm", "ResourcePool", "vm", new SelectionSpec[0]);
        TraversalSpec crToRp = PropertyCollectorUtil.createTraversalSpec("crToRp", "ComputeResource", "resourcePool", new String[]{"rpToRp", "rpToVm"});
        TraversalSpec crToH = PropertyCollectorUtil.createTraversalSpec("crToH", "ComputeResource", "host", new SelectionSpec[0]);
        TraversalSpec dcToHf = PropertyCollectorUtil.createTraversalSpec("dcToHf", "Datacenter", "hostFolder", new String[]{"visitFolders"});
        TraversalSpec dcToVmf = PropertyCollectorUtil.createTraversalSpec("dcToVmf", "Datacenter", "vmFolder", new String[]{"visitFolders"});
        TraversalSpec HToVm = PropertyCollectorUtil.createTraversalSpec("HToVm", "HostSystem", "vm", new String[]{"visitFolders"});
        return Arrays.asList(dcToVmf, dcToHf, crToH, crToRp, rpToRp, HToVm, rpToVm);
    }

    public static SelectionSpec[] buildFullTraversalV4() {
        List<TraversalSpec> tSpecs = PropertyCollectorUtil.buildFullTraversalV2NoFolder();
        TraversalSpec dcToDs = PropertyCollectorUtil.createTraversalSpec("dcToDs", "Datacenter", "datastoreFolder", new String[]{"visitFolders"});
        TraversalSpec vAppToRp = PropertyCollectorUtil.createTraversalSpec("vAppToRp", "VirtualApp", "resourcePool", new String[]{"rpToRp", "vAppToRp"});
        TraversalSpec dcToNetf = PropertyCollectorUtil.createTraversalSpec("dcToNetf", "Datacenter", "networkFolder", new String[]{"visitFolders"});
        TraversalSpec visitFolders = PropertyCollectorUtil.createTraversalSpec("visitFolders", "Folder", "childEntity", new String[]{"visitFolders", "dcToHf", "dcToVmf", "dcToDs", "dcToNetf", "crToH", "crToRp", "HToVm", "rpToVm"});
        SelectionSpec[] sSpecs = new SelectionSpec[tSpecs.size() + 4];
        sSpecs[0] = visitFolders;
        sSpecs[1] = dcToDs;
        sSpecs[2] = dcToNetf;
        sSpecs[3] = vAppToRp;
        for (int i2 = 4; i2 < sSpecs.length; ++i2) {
            sSpecs[i2] = tSpecs.get(i2 - 4);
        }
        return sSpecs;
    }
}

